<?php

namespace VM\NotesBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NoteDetails
 *
 * @ORM\Table(name="notedetails")
 * @ORM\Entity()
 */
class NoteDetails
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="position_x", type="decimal", scale=7, precision=6)
     */
    private $position_x;

    /**
     * @var float
     *
     * @ORM\Column(name="position_y", type="decimal", scale=7, precision=6)
     */
    private $position_y;

    /**
     * @var string
     *
     * @ORM\Column(name="note", type="text", nullable=true)
     */
    private $note;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set position_x
     *
     * @param string $positionX
     * @return NoteDetails
     */
    public function setPositionX($positionX)
    {
        $this->position_x = $positionX;
    
        return $this;
    }

    /**
     * Get position_x
     *
     * @return string 
     */
    public function getPositionX()
    {
        return $this->position_x;
    }

    /**
     * Set position_y
     *
     * @param string $positionY
     * @return NoteDetails
     */
    public function setPositionY($positionY)
    {
        $this->position_y = $positionY;
    
        return $this;
    }

    /**
     * Get position_y
     *
     * @return string 
     */
    public function getPositionY()
    {
        return $this->position_y;
    }

    /**
     * Set note
     *
     * @param string $note
     * @return NoteDetails
     */
    public function setNote($note)
    {
        $this->note = $note;
    
        return $this;
    }

    /**
     * Get note
     *
     * @return string 
     */
    public function getNote()
    {
        return $this->note;
    }
}